﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Liftable : Interactable {
	/// <summary> Current pickup held by the player </summary>
	public static Liftable carriedPickup;

	public override string Title { get { return displayName; } }
	public string displayName;

	public MeshRenderer mr { get { return _mr != null ? _mr : _mr = GetComponentInChildren<MeshRenderer>(); } }
	private MeshRenderer _mr;
	public Collider collider { get { return _collider != null ? _collider : _collider = GetComponentInChildren<Collider>(); } }
	private Collider _collider;
	public Rigidbody body { get { return _body != null ? _body : _body = GetComponent<Rigidbody>(); } }
	private Rigidbody _body;

	private Material tempMat;



	public override void Interact(bool player) {
		// Non-player lifts are not allowed
		if (!player) return;

		tempMat = mr.sharedMaterial;
		Color tempCol = mr.material.GetColor("_Color");
		tempCol.a = 0.5f;
		mr.material.SetColor("_Color", tempCol);
		mr.material.SetFloat("_Mode", 2);
		mr.material.SetInt("_SrcBlend", (int)UnityEngine.Rendering.BlendMode.SrcAlpha);
		mr.material.SetInt("_DstBlend", (int)UnityEngine.Rendering.BlendMode.OneMinusSrcAlpha);
		mr.material.SetInt("_ZWrite", 0);
		mr.material.DisableKeyword("_ALPHATEST_ON");
		mr.material.EnableKeyword("_ALPHABLEND_ON");
		mr.material.DisableKeyword("_ALPHAPREMULTIPLY_ON");
		mr.material.renderQueue = 3000;
		collider.enabled = false;
		body.isKinematic = true;
		carriedPickup = this;
	}

	public void Throw() {
		Destroy(mr.material);
		mr.sharedMaterial = tempMat;
		body.isKinematic = false;
		collider.enabled = true;
		body.AddForce(PlayerController.instance.transform.TransformVector(new Vector3(0, 1, 2)), ForceMode.VelocityChange);
		Liftable.carriedPickup = null;
	}
}