﻿using DialogueSystem;
using UnityEngine;
using UnityEngine.AI;

public class NPC : Interactable {
	public override string Title { get { return displayName; } }
	public string displayName;

	public Dialogue dialogue { get { return _dialogue != null ? _dialogue : _dialogue = GetComponent<Dialogue>(); } }
	private Dialogue _dialogue;

	public NavMeshAgent agent;
	public Animator animator;

	public override void Interact(bool player) {
		if (!player) return;
		if (dialogue != null) dialogue.Begin();
	}

	private void Update() {
		animator.SetBool("walking", agent.velocity.sqrMagnitude > 0f);
	}
}