﻿using System;
using UnityEngine;
using XNode;

namespace NPCScript {
	public abstract class NPCFlowNode : NPCNode {
		[Input(backingValue = ShowBackingValue.Never), HideInInspector] public NPCStartNode previous;
		[Output(connectionType = ConnectionType.Override), HideInInspector] public NPCStartNode next;

		[NonSerialized] public bool active;

		public void Enter() {
			active = true;
			OnEnter();
		}

		public abstract void OnEnter();
		public abstract void Update();

		protected void MoveNext(string outputName) {
			active = false;
			NodePort port = GetOutputPort(outputName);
			if (port == null) throw new ArgumentException("No port named " + outputName + " on " + name);
			NodePort targetPort = port.Connection;
			if (targetPort == null) return; // Finished
			(targetPort.node as NPCFlowNode).Enter();
		}
	}
}