﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using XNode;

namespace NPCScript {
	public class ProximityTriggerNode : NPCNode {
		[Output] public bool output;
		public float range;
		public Transform target;

		public override object GetValue(NodePort port) {
			return Vector3.Distance(graph.npc.transform.position, target.transform.position) < range;
		}
	}
}