﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class Player : MonoBehaviour {
	public static Player instance;

	[Header("References")]
	public Camera camera;
	public PlayerController controller;
	public PlayerHand hand;

	[Header("Data")]
	public PlayerInventory inventory = new PlayerInventory();
	public PlayerHotbar hotbar = new PlayerHotbar();
	public PlayerKeybinds keybinds = new PlayerKeybinds();

	private void Awake() {
		instance = this;
	}

	private void Start() {
		EnsureUIScene();
	}

	private void EnsureUIScene() {
		for (int i = 0; i < SceneManager.sceneCount; i++) {
			if (SceneManager.GetSceneAt(i).name == "UI") {
				return;
			}
		}
		SceneManager.LoadScene("UI", LoadSceneMode.Additive);
	}

	private void Update() {
		Hotkeys();
	}

	private void Hotkeys() {
		if (Input.GetKeyDown(keybinds.releaseMouse)) CursorManager.AddUser(this);
		else if (Input.GetKeyUp(keybinds.releaseMouse)) CursorManager.RemoveUser(this);

		if (Input.GetKeyDown(keybinds.inventory)) UIInventory.instance.Toggle();
		if (Input.GetKeyDown(keybinds.hotbarSlot0)) hotbar.SelectItem(0);
		if (Input.GetKeyDown(keybinds.hotbarSlot1)) hotbar.SelectItem(1);
		if (Input.GetKeyDown(keybinds.hotbarSlot2)) hotbar.SelectItem(2);
		if (Input.GetKeyDown(keybinds.hotbarSlot3)) hotbar.SelectItem(3);
		if (Input.GetKeyDown(keybinds.hotbarSlot4)) hotbar.SelectItem(4);
		if (Input.GetKeyDown(keybinds.hotbarSlot5)) hotbar.SelectItem(5);
		if (Input.GetKeyDown(keybinds.hotbarSlot6)) hotbar.SelectItem(6);
		if (Input.GetKeyDown(keybinds.hotbarSlot7)) hotbar.SelectItem(7);
		if (Input.GetKeyDown(keybinds.hotbarSlot8)) hotbar.SelectItem(8);
		if (Input.GetKeyDown(keybinds.hotbarSlot9)) hotbar.SelectItem(9);
		if (Input.GetKeyDown(keybinds.dropItem)) inventory.DropItem(hand.heldItem);

		if (hand.heldItem != null) {
			if (Input.GetKeyDown(keybinds.primary)) hand.heldItem.PrimaryFire();
			if (Input.GetKeyDown(keybinds.secondary)) hand.heldItem.SecondaryFire();
			if (Input.GetKeyDown(keybinds.reload)) hand.heldItem.Reload();
		}
	}
}