﻿using UnityEngine;

public class PlayerFlashlight : MonoBehaviour {
	public new Light light;
	public KeyCode key;
	public AudioSource source;
	public AudioClip onSound;
	public AudioClip offSound;
	public bool on { get; private set; }

	private void Update() {
		if (Input.GetKeyDown(key)) {
			on = !on;
			light.enabled = on;
			source.PlayOneShot(on ? onSound : offSound);
		}
	}
}