﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerHand : MonoBehaviour {
	public Item heldItem { get; private set; }

	private void Start() {
		Player.instance.hotbar.onSelectionChange -= OnSelectionChange;
		Player.instance.hotbar.onSelectionChange += OnSelectionChange;
	}

	private void OnSelectionChange() {
		Equip(Player.instance.hotbar.SelectedItem);
	}

	public void Equip(Item item) {
		// Unequip current
		if (heldItem != null) {
			heldItem.SetExistence(Item.ExistenceMode.Inventory);
		}

		// Equip new
		heldItem = item;
		if (heldItem != null) {
			item.SetExistence(Item.ExistenceMode.PlayerHand);
		}
	}
}