﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

[Serializable]
public class PlayerHotbar {
	private Item[] items = new Item[10];

	public Action onSelectionChange;
	public Action onItemsChange;

	public int selectedSlot { get; private set; }
	public Item SelectedItem { get { return selectedSlot != -1 ? items[selectedSlot] : null; } }

	public Item SelectNextItem() {
		selectedSlot++;
		if (selectedSlot > 9) selectedSlot = 0;
		return SelectItem(selectedSlot);
	}

	public Item SelectPreviousItem() {
		selectedSlot--;
		if (selectedSlot < 0) selectedSlot = 9;
		return SelectItem(selectedSlot);
	}

	public Item SelectItem(int index) {
		selectedSlot = index;
		if (onSelectionChange != null) onSelectionChange();
		return SelectedItem;
	}

	public void SetItem(int index, Item item) {
		if (item != null) {
			int prevIndex = Array.IndexOf(items, item);
			if (prevIndex != -1) items[prevIndex] = items[index];
		}
		items[index] = item;
		if (onItemsChange != null) onItemsChange();
		if (selectedSlot == index && onSelectionChange != null) onSelectionChange();
	}

	public bool RemoveItem(Item item) {
		for (int i = 0; i < items.Length; i++) {
			if (items[i] == item) {
				SetItem(i, null);
				if (onItemsChange != null) onItemsChange();
				if (selectedSlot == i && onSelectionChange != null) onSelectionChange();
				return true;
			}
		}
		return false;
	}

	/// <summary> Add item to hotbar if there is a free space </summary>
	public void AutoAddItem(Item item) {
		for (int i = 0; i < items.Length; i++) {
			if (items[i] == null) {
				SetItem(i, item);
				return;
			}
		}
	}

	public Item GetItem(int index) {
		return items[index];
	}

	public void Unselect() {
		selectedSlot = -1;
	}
}