﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerWeaponDrag : MonoBehaviour {
	public float intensity = 0.02f;
	public float smoothing = 5f;
	public float inertiaClamp = 0.05f;

	//private Quaternion restRot;
	//private Quaternion lastParentRot;
	//private Quaternion delta;

	//private Vector3 lastParentPos;
	private Vector3 lastPos;

	private void Start() {
		lastPos = transform.localPosition;

	}

	private void Update() {

		if (!Cursor.visible) {
			//weapon sway based on mouse movement * intensity, clamped to inertiaClamp
			float mouseX = Mathf.Clamp((-Input.GetAxis("Mouse X") * intensity), -inertiaClamp, inertiaClamp);
			float mouseY = Mathf.Clamp((-Input.GetAxis("Mouse Y") * intensity), -inertiaClamp, inertiaClamp);

			Vector3 targetPos = new Vector3(mouseX, mouseY, 0);
			transform.localPosition = Vector3.Lerp(transform.localPosition, lastPos + targetPos, Time.deltaTime * smoothing);
		}
	}
}