﻿using System;
using UnityEngine;
using UnityEngine.UI;

namespace DialogueSystem {
	public class UIDialogue : MonoBehaviour {
		public static UIDialogue instance;

		public Text nameLabel;
		public Text chatLabel;
		public OptionTemplate optionTemplate;

		private void Awake() {
			instance = this;
			optionTemplate.Initialize();
		}

		private void Start() {
			gameObject.SetActive(false);
		}

		private void Update() {
			// A click anywhere will skip to the next node when there are no options
			if (optionTemplate.items.Count == 0 && Input.GetMouseButtonDown(0)) {
				SelectAnswer(0);
			}
		}

		public void BeginConversation(Dialogue dialogue) {
			Dialogue.active = dialogue;
			CursorManager.AddUser(this);
			gameObject.SetActive(true);
			dialogue.graph.Restart();
			nameLabel.text = dialogue.name;
			LoadNode(dialogue.graph.current);
		}

		private void LoadNode(ChatNode node) {
			optionTemplate.Clear();
			chatLabel.text = node.text;
			for (int i = 0; i < node.answers.Count; i++) {
				UIDialogueOption option = optionTemplate.InstantiateTemplate();
				option.label.text = node.answers[i].text;
				option.index = i;
			}
		}

		public void SelectAnswer(int index) {
			ChatNode newNode = Dialogue.active.graph.AnswerQuestion(index);
			if (newNode != null) LoadNode(newNode);
			else EndConversation();
		}

		public void EndConversation() {
			Dialogue.active = null;
			gameObject.SetActive(false);
			CursorManager.RemoveUser(this);
		}

		[Serializable] public class OptionTemplate : Template<UIDialogueOption> { }
	}
}