using System;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

namespace DialogueSystem {
	public class UIDialogueOption : MonoBehaviour, IPointerEnterHandler, IPointerExitHandler, IPointerClickHandler {
		public Image background;
		public Text label;

		[NonSerialized] public int index;

		void IPointerEnterHandler.OnPointerEnter(PointerEventData eventData) {
			Highlight(true);
		}

		void IPointerExitHandler.OnPointerExit(PointerEventData eventData) {
			Highlight(false);
		}

		private void Highlight(bool hovered) {
			background.enabled = hovered;
			label.color = hovered ? Color.yellow : Color.blue;
		}

		void IPointerClickHandler.OnPointerClick(PointerEventData eventData) {
			UIDialogue.instance.SelectAnswer(index);
		}
	}
}