﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class UIInventory : UIWindow {
	public static UIInventory instance;

	public RectTransform inventoryContainer;
	public UIInventoryItemTemplate itemTemplate;

	private void Awake() {
		instance = this;
		itemTemplate.Initialize();
	}

	protected override void OnOpen() {
		Vector2 cellSize = inventoryContainer.rect.size / PlayerInventory.size;

		foreach (Item item in Player.instance.inventory.items) {
			UIInventoryItem uiItem = itemTemplate.InstantiateTemplate();
			uiItem.rectTransform.anchoredPosition = cellSize * item.shape.position * new Vector2(1, -1);
			uiItem.rectTransform.sizeDelta = cellSize * item.shape.size;
			uiItem.icon.sprite = item.icon;
			uiItem.item = item;
		}
	}

	protected override void OnClose() {
		itemTemplate.Clear();
	}

	[Serializable] public class UIInventoryItemTemplate : Template<UIInventoryItem> { };
}
