﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public static class CursorManager {
	private static HashSet<object> users = new HashSet<object>();

	public static void AddUser(object user) {
		users.Add(user);
		UpdateCursorState();
	}

	public static void RemoveUser(object user) {
		users.Remove(user);
		UpdateCursorState();
	}

	private static void UpdateCursorState() {
		if (users.Count == 0) {
			Cursor.visible = false;
			Cursor.lockState = CursorLockMode.Locked;
		} else {
			Cursor.visible = true;
			Cursor.lockState = CursorLockMode.None;
		}
	}
}
