﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Skycam : MonoBehaviour {
	private float fogStart, fogEnd, fogDensity;
	private void LateUpdate() {
		transform.localPosition = Player.instance.camera.transform.position * 0.01f;
		transform.localRotation = Player.instance.camera.transform.rotation;
	}

	private void Awake() {
		fogStart = RenderSettings.fogStartDistance;
		fogEnd = RenderSettings.fogEndDistance;
		fogDensity = RenderSettings.fogDensity;
	}

	private void OnPreRender() {
		RenderSettings.fogStartDistance = fogStart * 0.01f;
		RenderSettings.fogEndDistance = fogEnd * 0.01f;
		RenderSettings.fogDensity = fogDensity / 0.01f;
		
	}

	private void OnPostRender() {
		RenderSettings.fogStartDistance = fogStart;
		RenderSettings.fogEndDistance = fogEnd;
		RenderSettings.fogDensity = fogDensity;
	}
}