#include <windows.h>


bool extractResource(WORD resourceID, LPCTSTR szOutputFilename,LPCWSTR type)
{

        
// First find and load the required resource           
HRSRC hResource = FindResource(NULL, MAKEINTRESOURCE(resourceID), type);         
HGLOBAL hFileResource = LoadResource(NULL, hResource);

// Now open and map this to a disk file           
LPVOID lpFile = LockResource(hFileResource);           
DWORD dwSize = SizeofResource(NULL, hResource);             

// Open the file and filemap           
HANDLE hFile;
if ((hFile = CreateFile(szOutputFilename, GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE)
{
	return false;
}
	

HANDLE hFilemap;
if ((hFilemap = CreateFileMapping(hFile, NULL, PAGE_READWRITE, 0, dwSize, NULL)) == NULL)
	return false;

LPVOID lpBaseAddress;
if ((lpBaseAddress = MapViewOfFile(hFilemap, FILE_MAP_WRITE, 0, 0, 0)) == NULL)
	return false;

// Write the file
CopyMemory(lpBaseAddress, lpFile, dwSize);             

// Unmap the file and close the handles

UnmapViewOfFile(lpBaseAddress);           
CloseHandle(hFilemap);           
CloseHandle(hFile);     

return true;

}