/**
Fix installer, copies/modifies non-config files in Deus Ex directory using admin rights.
*/

#include <windows.h>
#include "resource.h"
#include <PowrProf.h>
#include "../deusexe/extractresource.h"
#include <stdio.h>
#include <shlwapi.h>

static OSVERSIONINFO windowsVer;
static wchar_t* deusExPath;
static wchar_t deusExExe[MAX_PATH];
/*
bool applyImageCFG()
{
	wchar_t temp[MAX_PATH];
	GetTempPath(MAX_PATH,temp);
	wcscat(temp,L"imagecfg.exe");
	if(!extractResource(IMAGECFG,temp,L"exe"))
		return false;
		
	wchar_t param[MAX_PATH]; //Build command line string
	wcscpy(param,L"-a 0x01 ");
	wcscat(param,L"\"");
	wcscat(param,deusExExe);
	wcscat(param,L"\"");
	if(ShellExecute(NULL,L"open",temp,param,NULL,NULL)<=(HINSTANCE)32)
		return false;
	
	DeleteFile(temp);	

	return true;
	
}
*/
/*
bool applyThrottling()
{
	if(windowsVer.dwMajorVersion < 6) //XP or lower
	{		
		unsigned int id;
		if(GetActivePwrScheme(&id)==0)
			return false;
		MACHINE_PROCESSOR_POWER_POLICY pol;	
		if(ReadProcessorPwrScheme(id,&pol)==0)
			return false;
		pol.ProcessorPolicyDc.DynamicThrottle = PO_THROTTLE_NONE;
		pol.ProcessorPolicyAc.DynamicThrottle = PO_THROTTLE_NONE;
		if(WriteProcessorPwrScheme(id,&pol)==0)
			return false;
		if(SetActivePwrScheme(id,0,0)==0)
			return false;
		return true;
	}
	else //Vista; dynamically load the functions (otherwise the program won't run on XP, complaining about these functions not being there)
	{
		HMODULE lib = LoadLibrary(L"powrprof.dll");


		typedef DWORD  ( __stdcall *PowerWriteACValueIndexP) (    __in_opt HKEY RootPowerKey,    __in CONST GUID *SchemeGuid,    __in_opt CONST GUID *SubGroupOfPowerSettingsGuid,    __in_opt CONST GUID *PowerSettingGuid,    __in DWORD AcValueIndex );
		typedef DWORD ( __stdcall *PowerWriteDCValueIndexP) (    __in_opt HKEY RootPowerKey,    __in CONST GUID *SchemeGuid,    __in_opt CONST GUID *SubGroupOfPowerSettingsGuid,    __in_opt CONST GUID *PowerSettingGuid,    __in DWORD DcValueIndex    );
		typedef DWORD ( __stdcall *PowerGetActiveSchemeP) (    __in_opt HKEY UserRootPowerKey,    __deref_out GUID **ActivePolicyGuid    );
		typedef DWORD  ( __stdcall *PowerSetActiveSchemeP) (    __in_opt HKEY UserRootPowerKey,    __in_opt CONST GUID *SchemeGuid    );

		PowerWriteACValueIndexP PowerWriteACValueIndex = (PowerWriteACValueIndexP) GetProcAddress(lib,"PowerWriteACValueIndex");
		PowerWriteACValueIndexP PowerWriteDCValueIndex = (PowerWriteDCValueIndexP) GetProcAddress(lib,"PowerWriteDCValueIndex");
		PowerGetActiveSchemeP PowerGetActiveScheme = (PowerGetActiveSchemeP) GetProcAddress(lib,"PowerGetActiveScheme");
		PowerSetActiveSchemeP PowerSetActiveScheme = (PowerSetActiveSchemeP) GetProcAddress(lib,"PowerSetActiveScheme");
		GUID* id;
		if(PowerGetActiveScheme(0,&id) != ERROR_SUCCESS)
			return false;
		if(PowerWriteACValueIndex(0,id,&GUID_PROCESSOR_SETTINGS_SUBGROUP,&GUID_PROCESSOR_THROTTLE_MINIMUM,100) != ERROR_SUCCESS)
			return false;
		if(PowerWriteACValueIndex(0,id,&GUID_PROCESSOR_SETTINGS_SUBGROUP,&GUID_PROCESSOR_THROTTLE_MAXIMUM,100) != ERROR_SUCCESS)
			return false;
		if(PowerWriteDCValueIndex(0,id,&GUID_PROCESSOR_SETTINGS_SUBGROUP,&GUID_PROCESSOR_THROTTLE_MINIMUM,100) != ERROR_SUCCESS)
			return false;
		if(PowerWriteDCValueIndex(0,id,&GUID_PROCESSOR_SETTINGS_SUBGROUP,&GUID_PROCESSOR_THROTTLE_MAXIMUM,100) != ERROR_SUCCESS)
			return false;
		if(PowerSetActiveScheme(0,id) != ERROR_SUCCESS)
			return false;
		LocalFree(&id);
		FreeLibrary(lib);

		return true;
	}
}
*/
bool applyGUIScaling()
{
	wchar_t temp[MAX_PATH];
	PathCombine(temp,deusExPath,L"detoured.dll");
	if(!extractResource(DETOUREDDLL,temp,L"EXE"))
		return false;
	PathCombine(temp,deusExPath,L"otpuifix.dll");
	if(!extractResource(OTPUIFIXDLL,temp,L"EXE"))
		return false;
	PathCombine(temp,deusExPath,L"otpuifix.u");
	if(!extractResource(OTPUIFIXU,temp,L"EXE"))
		return false;

	return true;
}

/*
bool applyLauncher()
{
	
	if(!extractResource(LAUNCHER,deusExExe,L"exe"))
		return false;

	return true;
}
*/
int wmain(int argc, wchar_t *argv[])
{

	if(argc<3)
	{
		puts("Parameters: command, DX path");
		return EXIT_FAILURE;
	}

	wchar_t* command = argv[1];
	deusExPath = argv[2];
	PathCombine(deusExExe,deusExPath,L"\\deusex.exe");

	windowsVer.dwOSVersionInfoSize = sizeof(windowsVer);
	GetVersionEx(&windowsVer);
	
/*
	if(wcscmp(command,L"imagecfg")==0) //CPU fix
	{
		if(!applyImageCFG())
		{
			puts("Error applying multi processor fix.");
			return EXIT_FAILURE;
		}
	}
	else if(wcscmp(command,L"throttling")==0) //throttling fix
	{
		if(!applyThrottling())
		{
			puts("Error applying throttling fix.");
			return EXIT_FAILURE;
		}
	}
	else */if(wcscmp(command,L"guiscaling")==0) //Scaling fix
	{
		if(!applyGUIScaling())
		{
			puts("Error applying GUI scaling fix.");
			return EXIT_FAILURE;
		}
	}
/*	else if(wcscmp(command,L"launcher")==0) //Alternative launcher
	{
		if(!applyLauncher())
		{
			puts("Error applying launcher fix.");
			return EXIT_FAILURE;
		}
	}
*/
	return EXIT_SUCCESS;
}