/*=============================================================================
File manager modified to use My Documents
=============================================================================*/


#include "FFileManagerWindows.h"
#include "Shlwapi.h"
#include "extractresource.h"
#include "resource.h"

class FFileManagerDeusExe : public FFileManagerWindows
{
	private:
	TCHAR userDataPath[MAX_PATH];


	/**
	Convert file paths to 'modern' ones in. When reading, the original file is used if it exists, writing is always to appdata.
	*/
	void toModernFileName(TCHAR* newName, const TCHAR* filename, char op = 'r')
	{	

		if(wcswcs(filename,userDataPath)) //Already modern path
		{
			wcscpy_s(newName,MAX_PATH,filename);
			return;
		}

		//Log files use absolute paths so catch that and put them in whatever their current subdir is
		if(wcscmp(PathFindExtension(filename),L".log")==0)
		{
			PathCombine(newName,userDataPath,PathFindFileName(filename));
			return;
		}
		
		PathCombine(newName,userDataPath,filename);
		wchar_t temp[MAX_PATH];
		GetCurrentDirectory(MAX_PATH,temp);

		if( !PathFileExists(newName) && PathFileExists(filename) && op=='r' ) //If opening a file that already exists, return original.
		{
			wcscpy_s(newName,MAX_PATH,filename);
			return;
		}
			
	}

public:
	FFileManagerDeusExe()
	{		
		wchar_t temp[MAX_PATH];
		SHGetFolderPath(NULL,CSIDL_PERSONAL,NULL,NULL,userDataPath);
		PathAppend(userDataPath,L"Deus Ex");
		CreateDirectory(userDataPath,NULL);
		PathAppend(userDataPath,L"System");
		CreateDirectory(userDataPath,NULL);

		PathCombine(temp,userDataPath,L"..\\Save");
		CreateDirectory(temp,NULL);

		//Extract default ini files if missing
		PathCombine(temp,userDataPath,L"deusex.ini");
		if(!PathFileExists(temp))
			extractResource(DEFINI,temp,L"INI");
		PathCombine(temp,userDataPath,L"user.ini");
		if(!PathFileExists(temp))
			extractResource(DEFUSERINI,temp,L"INI");
	}

	FArchive* CreateFileReader( const TCHAR* _Filename, DWORD Flags, FOutputDevice* Error )
	{
		TCHAR Filename[MAX_PATH];
		toModernFileName(Filename,_Filename);
		return FFileManagerWindows::CreateFileReader(Filename,Flags,Error);
	}
	FArchive* CreateFileWriter( const TCHAR* _Filename, DWORD Flags, FOutputDevice* Error )
	{
		TCHAR Filename[MAX_PATH];
		toModernFileName(Filename,_Filename,'w');
		return FFileManagerWindows::CreateFileWriter(Filename,Flags,Error);
	}
	INT FileSize( const TCHAR* _Filename )
	{
		TCHAR Filename[MAX_PATH];
		toModernFileName(Filename,_Filename);
		return FFileManagerWindows::FileSize(Filename);
	}
	UBOOL Copy( const TCHAR* _DestFile, const TCHAR* _SrcFile, UBOOL ReplaceExisting, UBOOL EvenIfReadOnly, UBOOL Attributes, void (*Progress)(FLOAT Fraction) )
	{
		wchar_t DestFile[MAX_PATH];
		toModernFileName(DestFile,_DestFile,'w');
		wchar_t SrcFile[MAX_PATH];
		toModernFileName(SrcFile,_SrcFile);
		return FFileManagerWindows::Copy(DestFile,SrcFile,ReplaceExisting,EvenIfReadOnly,Attributes,Progress);
	}
	UBOOL Delete( const TCHAR* _Filename, UBOOL RequireExists=0, UBOOL EvenReadOnly=0 )
	{
		TCHAR Filename[MAX_PATH];
		toModernFileName(Filename,_Filename);
		return FFileManagerWindows::Delete(Filename,RequireExists,EvenReadOnly);
	}
	UBOOL Move( const TCHAR* _Dest, const TCHAR* _Src, UBOOL Replace=1, UBOOL EvenIfReadOnly=0, UBOOL Attributes=0 )
	{
		wchar_t Dest[MAX_PATH];
		toModernFileName(Dest,_Dest);
		wchar_t Src[MAX_PATH];
		toModernFileName(Src,_Src);
		return FFileManagerWindows::Move(Dest,Src,Replace,EvenIfReadOnly,Attributes);
	}
	
	UBOOL MakeDirectory( const TCHAR* _Path, UBOOL Tree=0 )
	{
		wchar_t Path[MAX_PATH];
		toModernFileName(Path,_Path,'w');
		return FFileManagerWindows::MakeDirectory(Path,Tree);
	}

	UBOOL DeleteDirectory( const TCHAR* _Path, UBOOL RequireExists=0, UBOOL Tree=0 )
	{
		wchar_t Path[MAX_PATH];
		toModernFileName(Path,_Path);
		return FFileManagerWindows::DeleteDirectory(Path,RequireExists,Tree);
	}

	TArray<FString> FindFiles( const TCHAR* _Filename, UBOOL Files, UBOOL Directories )
	{

		wchar_t Filename[MAX_PATH];
		toModernFileName(Filename,_Filename);


		guard(FFileManagerWindows::FindFiles);
		TArray<FString> Result;
		HANDLE Handle=NULL;

		
		WIN32_FIND_DATAW Data;

		//Look for old style files
		Handle=FindFirstFileW(_Filename,&Data);
		if( Handle!=INVALID_HANDLE_VALUE )
			do
				if
				(	appStricmp(Data.cFileName,TEXT("."))
				&&	appStricmp(Data.cFileName,TEXT(".."))
				&&	((Data.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)?Directories:Files) )
					new(Result)FString(Data.cFileName);
			while( FindNextFileW(Handle,&Data) );

		if( Handle )
			FindClose( Handle );
		
		if(wcscmp(Filename,_Filename)==0) //Already started out with a new style file
			return Result;

		//Look for new files
		Handle=FindFirstFileW(Filename,&Data);
		if( Handle!=INVALID_HANDLE_VALUE )
			do
				if
				(	appStricmp(Data.cFileName,TEXT("."))
				&&	appStricmp(Data.cFileName,TEXT(".."))
				&&	((Data.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)?Directories:Files) )
					new(Result)FString(Data.cFileName);
			while( FindNextFileW(Handle,&Data) );
		

		if( Handle )
			FindClose( Handle );
		return Result;
		unguard;
		
	}
};