#include <windows.h>
#include <cstdio>
#include "launcherdialog.h"
#include "fixapp.h"

INT_PTR CALLBACK launcherDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
switch (uMsg)
	{

	case WM_INITDIALOG:
		SendMessage(hwndDlg, WM_SETICON, ICON_BIG, (LPARAM) LoadIcon((HINSTANCE) GetWindowLong(hwndDlg,GWL_HINSTANCE), MAKEINTRESOURCE(IDI_ICON)));

		//Grab version info from resource
		{
			wchar_t fileName[MAX_PATH];
			GetModuleFileName(0,fileName,MAX_PATH);
			DWORD handle; //Doesnt do anything but still needed
			DWORD size = GetFileVersionInfoSize(fileName,&handle);
			char* data = new char[size];
			GetFileVersionInfo(fileName,0,size,data);
			void* version = nullptr;
			
			UINT len;			
			VerQueryValue(static_cast<void*>(data),L"\\StringFileInfo\\041304b0\\ProductVersion",static_cast<void**>(&version),&len);
			
			wchar_t buffer[25];
			swprintf_s(buffer,25,L"Version %ls",version);
			SetDlgItemText(hwndDlg,IDC_VERSION,buffer);
		
			delete [] data;
		}
		return true;

	
	case WM_COMMAND:
	{
		switch(LOWORD(wParam))
		{	
			case (IDC_PLAY):				
				EndDialog(hwndDlg,1);
				return true;
			case (IDC_EXIT):
				EndDialog(hwndDlg,0);
				return true;
			case (IDC_CONFIG):
				DialogBox(GetModuleHandle(0),MAKEINTRESOURCE(IDD_DIALOG2),hwndDlg,&fixerDialogProc);
				return true;
		}
		break;
	}
	

	case WM_CLOSE:
		EndDialog(hwndDlg,0);
		return true;

	default:
		break;
	}

	return false;
}