#include <Windows.h>

#include <algorithm>

#include "detours.h"

#include "detoureds.h"


/**
GetDiskFreeSpaceExA
*/
static BOOL (WINAPI* TrueGetDiskFreeSpaceExA) (LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes) = GetDiskFreeSpaceExA;

BOOL WINAPI MyGetDiskFreeSpaceExA(LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes)
{
	//Fix support for very large harddrives that would result in a size being returned that the game sees as negative
	BOOL retval = TrueGetDiskFreeSpaceExA(lpDirectoryName,lpFreeBytesAvailableToCaller,lpTotalNumberOfBytes,lpTotalNumberOfFreeBytes);
	lpFreeBytesAvailableToCaller->QuadPart=std::min<ULONGLONG>(lpFreeBytesAvailableToCaller->QuadPart,0xffffffffU); //More than 4gb free, then return 4gb; chosen as game was written with FAT in mind and as it probably uses an 32 bit type for this		
	return retval;
}

bool initDetours()
{
	if(DetourTransactionBegin()!=NO_ERROR)
		return false;
	if(DetourUpdateThread(GetCurrentThread())!=NO_ERROR)
		return false;		
	if(DetourAttach(&(PVOID&)TrueGetDiskFreeSpaceExA, MyGetDiskFreeSpaceExA)!=NO_ERROR)
		return false;
	if(DetourTransactionCommit()!=NO_ERROR)
		return false;
	return true;
}

bool uninitDetours()
{
	if(DetourTransactionBegin()!=NO_ERROR)
		return false;
	if(DetourUpdateThread(GetCurrentThread())!=NO_ERROR)
		return false;
	if(DetourDetach(&(PVOID&)TrueGetDiskFreeSpaceExA, MyGetDiskFreeSpaceExA)!=NO_ERROR)
		return false;
	if(DetourTransactionCommit()!=NO_ERROR)
		return false;
	return true;
}