#include <windows.h>
#include <ShlObj.h>
#include <Shlwapi.h>
#include "misc.h"

static const wchar_t* GAMENAME = L"Deus Ex";

bool SetDEP(DWORD dwFlags = PROCESS_DEP_ENABLE)
{

       HMODULE hMod = GetModuleHandleW(L"Kernel32.dll");

		if (!hMod)
		{
			return FALSE;
		}

       typedef BOOL (WINAPI *PSETDEP)(DWORD);

       PSETDEP procSet = (PSETDEP)GetProcAddress(hMod,"SetProcessDEPPolicy");

       if (!procSet)
	   {
		   return FALSE;
	   }

       return procSet(dwFlags)!=FALSE;

}

static bool useUserDocs;

bool getUseUserDocs()
{
	return useUserDocs;
}

void setUseUserDocs(bool val)
{
	useUserDocs = val;
}

/**
Returns System directory in user documents directory
*/
void getUserDocsDir(wchar_t buf[MAX_PATH])
{
	SHGetFolderPath(NULL,CSIDL_PERSONAL,NULL,NULL,buf);
	PathAppend(buf,GAMENAME);
	PathAppend(buf,L"\\System");
}

/**
Returns System directory in game directory
*/
void getGameDir(wchar_t buf[MAX_PATH])
{
	GetModuleFileName(NULL,buf,MAX_PATH);
	PathRemoveFileSpec(buf);
}