#pragma comment(linker,"/manifestdependency:\"type='win32' name='Microsoft.Windows.Common-Controls' version='6.0.0.0' processorArchitecture='*' publicKeyToken='6595b64144ccf1df' language='*'\"")

#include <windows.h>
#include <windowsx.h>
#include <shlobj.h>

#include "engine.h"
#include "window.h"
#include "unrender.h"
#include "FMallocWindows.h"
#include "FOutputDeviceFile.h"
#include "FOutputDeviceWindowsError.h"
#include "FFeedbackContextWindows.h"
#include "FConfigCacheIni.h"

#include "DeusExeFileManager.h"
#include "misc.h"
#include "rawinput.h"
#include "launcherdialog.h"
#include "fixapp.h"
#include "detoureds.h"

FMallocWindows Malloc;
FOutputDeviceFile Log;
FOutputDeviceWindowsError Error;
FFeedbackContextWindows Warn;
FFileManagerDeusExe FileManager;

extern "C" {TCHAR GPackage[64]=TEXT("Launch");}
static LARGE_INTEGER perfCounterFreq;
static int FPSLimit;

static UBOOL directInput = 0;
static HWND hWnd;

static UEngine* InitEngine()
{
	// Create the global engine object.
	UClass* EngineClass;
	EngineClass = UObject::StaticLoadClass( UGameEngine::StaticClass(), NULL, TEXT("ini:Engine.Engine.GameEngine"), NULL, LOAD_NoFail, NULL );
	UEngine* Engine = ConstructObject<UEngine>( EngineClass );
	Engine->Init();
	
	return Engine;
}

static void MainLoop( UEngine* Engine )
{

	float deltaTime;
	LARGE_INTEGER oldTime;
	LARGE_INTEGER time;

	QueryPerformanceCounter(&oldTime); //Initial time
	
	MSG Msg;
	while(GIsRunning && !GIsRequestingExit)
	{
		
		QueryPerformanceCounter(&time);
		deltaTime  =  (time.QuadPart-oldTime.QuadPart) / (float)perfCounterFreq.QuadPart;

		//Lock game update speed to fps limit
		if(FPSLimit == 0 || deltaTime>=1.0f/FPSLimit)
		{
			Engine->Tick(deltaTime);
			if( GWindowManager )
			{
				GWindowManager->Tick(deltaTime);
			}
			oldTime.QuadPart = time.QuadPart;
		}

		//Get rid of double mouse cursors in DirectInput mode as they go out of sync (making you click outside the window)
		if(directInput)
		{
			if(GetFocus()==hWnd)
			{
				RECT rect;
				GetWindowRect (hWnd,&rect);
				while(ShowCursor(FALSE)>0); //Hide cursor
				SetCursorPos((rect.left+rect.right)/2,(rect.top+rect.bottom)/2); //Center on window
			}
			else
			{
				ShowCursor(TRUE);
			}
		}
		
		while(PeekMessage(&Msg,NULL,0,0,PM_REMOVE))
		{
			bool skip=false;

			switch(Msg.message)
			{
				case WM_QUIT:
					GIsRequestingExit = 1;
					break;
				case WM_MOUSEMOVE: //The issue is that DirectInput means these are ignored, as we're fixing that make sure they won't get catched anyway
					if(directInput)
					{
						skip=true;
					}
					break;
				case WM_INPUT: //Fix menu mouse cursor in DirectInput mode.
					{
						if(directInput)
						{
							RAWINPUT raw;
							unsigned int rawSize = sizeof(raw);
							GetRawInputData((HRAWINPUT)Msg.lParam, RID_INPUT, &raw, &rawSize, sizeof(RAWINPUTHEADER));
							if(Engine->Client->Viewports.Num())
							{
								Engine->MouseDelta(Engine->Client->Viewports(0),0,raw.data.mouse.lLastX/1.5,raw.data.mouse.lLastY/1.5);									
							}
							skip=true;
						}

					}
					break;

			}

			if(!skip)
			{
				TranslateMessage( &Msg );
				DispatchMessage( &Msg );
			}
		}
		
	
	}
}

INT WINAPI WinMain( HINSTANCE hInInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow )
{
	INITCOMMONCONTROLSEX commonInfo;
	commonInfo.dwSize = sizeof(INITCOMMONCONTROLSEX);
	commonInfo.dwICC = ICC_LISTVIEW_CLASSES;
	if(InitCommonControlsEx(&commonInfo)!=TRUE)
	{
		return EXIT_FAILURE;
	}

	//Overwrite default settings. I'd rather not change default.ini but the game copies it over real system.ini before I'm able to patch up that
	wchar_t iniLoc[MAX_PATH];
	getGameSystemDir(iniLoc);
	PathAppend(iniLoc,L"Default.ini");
	WritePrivateProfileString(L"Engine.Engine",L"GameRenderDevice",L"D3DDrv.D3DRenderDevice",iniLoc);
	WritePrivateProfileString(L"WinDrv.WindowsClient",L"FullscreenColorBits",L"32",iniLoc);

	//If -localdata command line option present, don't use user documents for data
	setUseUserDocs(wcswcs(GetCommandLine(),L"-localdata")==nullptr);
	
	//Init core	
	appStrcpy( GPackage, appPackage() );
	appInit(GPackage,GetCommandLine(), &Malloc, &Log, &Error, &Warn, &FileManager, FConfigCacheIni::Factory, 1);

	GIsStarted = 1;
	GIsServer = 1;
	GIsClient = !ParseParam(appCmdLine(), TEXT("SERVER"));
	GIsEditor = 0;
	GIsScriptable = 1;
	GLazyLoad = 0;
	GConfig->Flush(false);
	bool skipLauncherDialog = (!GIsClient || ParseParam(appCmdLine(), TEXT("skipdialog")));

	if(initDetours()==false)
		Log.Log(L"Failed to initialize detours.");
	if(SetProcessAffinityMask(GetCurrentProcess(),0x1)==FALSE) //Force on single CPU
		Log.Log(L"Failed to set process affinity.");
	if(SetDEP(0)==FALSE) //Disable DEP for process (also need NXCOMPAT=NO)
		Log.Log(L"Failed to set process DEP flags.");
	if(QueryPerformanceFrequency(&perfCounterFreq)==FALSE)
		Error.Log(L"Failed to query performance counter.");
	
	//Show launcher dialog
	if( ParseParam(appCmdLine(),TEXT("changevideo")))
	{
		DialogBox(GetModuleHandle(0),MAKEINTRESOURCE(IDD_DIALOG2),0,&fixerDialogProc);
	}
	else if(!skipLauncherDialog && DialogBox(hInInstance,MAKEINTRESOURCE(IDD_DIALOG1),0,&launcherDialogProc)!=1)
	{
		appPreExit();
		appExit();
		return EXIT_SUCCESS;
	}
	GConfig->Flush(true); //Reload config file to pick up any changes made by fixer app.
	
	
	//Init windowing
	InitWindowing();
	

	//Create log window
	GLogWindow = new WLog( Log.Filename, Log.LogAr, TEXT("GameLog") );
	GLogWindow->OpenWindow(false, 0 );
	GLogWindow->Log( NAME_Title, LocalizeGeneral("Start") );
	
	//Init engine
	UEngine* Engine = InitEngine();
	GConfig->GetBool(L"WinDrv.WindowsClient",L"UseDirectInput",directInput);
	hWnd = (HWND) Engine->Client->Viewports(0)->GetWindow();
	
	if(directInput)
	{
		if(!registerRawInput(hWnd))
			Error.Log(L"Failed to register raw input device.");
	}

	
	GConfig->GetInt(L"WinDrv.WindowsClient",L"FPSLimit",FPSLimit);

	//Main loop
	GIsRunning = 1;
	if(!GIsRequestingExit)
	{
			MainLoop(Engine);
	}
	GIsRunning = 0;

	//Uninit
	GLogWindow->Log(NAME_Title, LocalizeGeneral("Exit"));
	delete GLogWindow;
	appPreExit();
	appExit();
	GIsStarted = 0;

	uninitDetours();
	return EXIT_SUCCESS;
}