#include <Windows.h>
#include <algorithm>
#include "detours.h"
#include "detoureds.h"
#include <limits>

/**
GetDiskFreeSpaceExA
*/
static BOOL (WINAPI* TrueGetDiskFreeSpaceExA) (LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes) = GetDiskFreeSpaceExA;

BOOL WINAPI MyGetDiskFreeSpaceExA(LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes)
{
	//The game interprets the returned amount of free disk space as a signed 32 bit value, so clip to that
	BOOL retval = TrueGetDiskFreeSpaceExA(lpDirectoryName,lpFreeBytesAvailableToCaller,lpTotalNumberOfBytes,lpTotalNumberOfFreeBytes);
	lpFreeBytesAvailableToCaller->QuadPart=std::min<ULONGLONG>(lpFreeBytesAvailableToCaller->QuadPart,std::numeric_limits<signed int>::max());
	return retval;
}

bool initDetours()
{
	if(DetourTransactionBegin()!=NO_ERROR)
		return false;
	if(DetourUpdateThread(GetCurrentThread())!=NO_ERROR)
		return false;		
	if(DetourAttach(&(PVOID&)TrueGetDiskFreeSpaceExA, MyGetDiskFreeSpaceExA)!=NO_ERROR)
		return false;
	if(DetourTransactionCommit()!=NO_ERROR)
		return false;
	return true;
}

bool uninitDetours()
{
	if(DetourTransactionBegin()!=NO_ERROR)
		return false;
	if(DetourUpdateThread(GetCurrentThread())!=NO_ERROR)
		return false;
	if(DetourDetach(&(PVOID&)TrueGetDiskFreeSpaceExA, MyGetDiskFreeSpaceExA)!=NO_ERROR)
		return false;
	if(DetourTransactionCommit()!=NO_ERROR)
		return false;
	return true;
}