#include <windows.h>
#include <Shlwapi.h>

#include <Core.h>
#include <FConfigCacheIni.h>

#include <cstdio>

#include "launcherdialog.h"
#include "datadirdialog.h"
#include "fixapp.h"
#include "misc.h"

INT_PTR CALLBACK launcherDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
switch (uMsg)
	{

	case WM_INITDIALOG:
		SendMessage(hwndDlg, WM_SETICON, ICON_BIG, reinterpret_cast<LPARAM>(LoadIcon(reinterpret_cast<HINSTANCE>( GetWindowLong(hwndDlg,GWL_HINSTANCE)), MAKEINTRESOURCE(IDI_ICON))));

		//Grab version info from resource
		{
			wchar_t fileName[MAX_PATH];
			GetModuleFileName(0,fileName,_countof(fileName));
			DWORD handle; //Doesnt do anything but still needed
			DWORD size = GetFileVersionInfoSize(fileName,&handle);
			char* data = new char[size];
			GetFileVersionInfo(fileName,0,size,data);
			void* version = nullptr;
			
			UINT len;			
			VerQueryValue(static_cast<void*>(data),L"\\StringFileInfo\\041304b0\\ProductVersion",static_cast<void**>(&version),&len);
			
			wchar_t buffer[25];
			swprintf_s(buffer,25,L"Version %ls",version);
			SetDlgItemText(hwndDlg,IDC_VERSION,buffer);
		
			delete [] data;
		}

		//Show ini files
		{
			FConfigCacheIni* ci = static_cast<FConfigCacheIni*>(GConfig);
			wchar_t ini1[MAX_PATH];
			wchar_t ini2[MAX_PATH];
			wcscpy_s(ini1,_countof(ini1),FSTRINGCAST(ci->SystemIni));
			wcscpy_s(ini2,_countof(ini1),FSTRINGCAST(ci->UserIni));						
			PathSetDlgItemPath(hwndDlg,IDC_INIFILES1,PathFindFileName(ini1));
			PathSetDlgItemPath(hwndDlg,IDC_INIFILES2,PathFindFileName(ini2));
		}

		return true;

	
	case WM_COMMAND:
	{
		switch(LOWORD(wParam))
		{	
			case (IDC_PLAY):				
				EndDialog(hwndDlg,1);
				SetWindowLongPtr(hwndDlg,DWL_MSGRESULT,0);
				return true;
			case (IDC_EXIT):
				EndDialog(hwndDlg,0);
				SetWindowLongPtr(hwndDlg,DWL_MSGRESULT,0);
				return true;
			case (IDC_DATADIRS):
				DialogBox(GetModuleHandle(0),MAKEINTRESOURCE(IDD_DATADIRS),hwndDlg,&dataDirDialogProc);
				SetWindowLongPtr(hwndDlg,DWL_MSGRESULT,0);
				return true;
			case (IDC_CONFIG):
				DialogBox(GetModuleHandle(0),MAKEINTRESOURCE(IDD_DIALOG2),hwndDlg,&fixerDialogProc);
				SetWindowLongPtr(hwndDlg,DWL_MSGRESULT,0);
				return true;			
		}
		break;
	}
	

	case WM_CLOSE:
		EndDialog(hwndDlg,0);
		return true;

	default:
		break;
	}

	return false;
}