#pragma once

class CDataDirDialog
{
public:
	explicit CDataDirDialog();
	virtual ~CDataDirDialog();
	bool Show(HWND hWndParent) const;

private:
	void MoveListItem(int iIndex, int iNewIndex) const;
	void SearchDir(const wchar_t* pszTargetDir, bool bRoot, const wchar_t* pszCurrentDir) const;
	void PopulateList() const;
	void PopulateConfig() const;

	static INT_PTR CALLBACK DataDirDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);

	HWND m_hWnd;
	HWND m_hWndList;
	static const wchar_t* sm_pszPaths;

	/**
	Default directories the game starts out with and should be ignored.
	*/
	typedef std::array<const wchar_t*,10> StandardDirsArray;
	static const StandardDirsArray sm_StandardDirs;

	/**
	Extensions that make sense to show
	*/
	typedef std::array<const wchar_t*,6> SupportedExtensionsArray;
	static const SupportedExtensionsArray sm_SupportedExtensions;

	static HWND s_hWndList;
};