#pragma once

class CFixApp
{
public:
	explicit CFixApp();
	virtual ~CFixApp();
	bool Show(HWND hWndParent) const;

private:	
	void SetFOV(int iFOV) const;
	int GetFOV() const;
	void ReadSettings() const;
	void PopulateDialog();
	void ApplySettings() const;

	static INT_PTR CALLBACK FixAppDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);

	//Constants
	static const wchar_t*       sm_pszOTPRootWindow;
	static const wchar_t*       sm_pszDefaultRootWindow;
	static const unsigned short sm_iFov_4_3 = 75;
	static const unsigned short sm_iFov_16_10 = 85;
	static const unsigned short sm_iFov_5_4 = 71;
	static const unsigned short sm_iFov_15_9 = 88;
	static const unsigned short sm_iFov_16_9 = 91;
	static const unsigned char  sm_iBPP_16 = 16;
	static const unsigned char  sm_iBPP_32 = 32;

	struct Resolution //These are all ints to match what Unreal loads from the ini file
	{
		int iX;
		int iY;
		int iFov;
	};

	typedef std::array<const Resolution,19> ResolutionArray;
	static const ResolutionArray sm_Resolutions;

	//Members
	HWND m_hWnd;
	std::vector<std::wstring> m_Renderers;
};
