#include "stdafx.h"
#include "LauncherDialog.h"
#include "DataDirDialog.h"
#include "FixApp.h"
#include "Misc.h"
#include "resource.h"

CLauncherDialog::CLauncherDialog()
{

}

CLauncherDialog::~CLauncherDialog()
{

}

bool CLauncherDialog::Show(HWND hWndParent) const
{
	return DialogBoxParam(GetModuleHandle(0),MAKEINTRESOURCE(IDD_DIALOG1),hWndParent,LauncherDialogProc,reinterpret_cast<LPARAM>(this)) == 1;
}

INT_PTR CALLBACK CLauncherDialog::LauncherDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM /*lParam*/)
{
	switch (uMsg)
	{

	case WM_INITDIALOG:
		{
			SendMessage(hwndDlg, WM_SETICON, ICON_BIG, reinterpret_cast<LPARAM>(LoadIcon(reinterpret_cast<HINSTANCE>(GetWindowLong(hwndDlg,GWL_HINSTANCE)), MAKEINTRESOURCE(IDI_ICON))));

			//Grab version info from resource
			wchar_t szFileName[MAX_PATH];
			GetModuleFileName(0,szFileName,_countof(szFileName));
			DWORD dwHandle; //Doesn't do anything but still needed
			DWORD dwSize = GetFileVersionInfoSize(szFileName,&dwHandle);
			std::unique_ptr<char[]> DataPtr(new char[dwSize]);
			GetFileVersionInfo(szFileName,0,dwSize,DataPtr.get());
			void* version = nullptr;

			UINT iLen;			
			VerQueryValue(DataPtr.get(),L"\\StringFileInfo\\041304b0\\ProductVersion",&version,&iLen);

			wchar_t buffer[25];
			swprintf_s(buffer,L"Version %ls",version);
			SetDlgItemText(hwndDlg,IDC_VERSION,buffer);

			//Show ini files
			assert(GConfig);
			FConfigCacheIni* pCI = static_cast<FConfigCacheIni*>(GConfig);
			wchar_t szIni1[MAX_PATH];
			wchar_t szIni2[MAX_PATH];
			wcscpy_s(szIni1,*pCI->SystemIni);
			wcscpy_s(szIni2,*pCI->UserIni);
			PathSetDlgItemPath(hwndDlg,IDC_INIFILES1,PathFindFileName(szIni1));
			PathSetDlgItemPath(hwndDlg,IDC_INIFILES2,PathFindFileName(szIni2));
		}

		return TRUE;


	case WM_COMMAND:
		switch(LOWORD(wParam))
		{	
		case IDC_PLAY:
			EndDialog(hwndDlg,1);
			return TRUE;
		case IDC_EXIT:
			EndDialog(hwndDlg,0);
			return TRUE;
		case IDC_DATADIRS:
			{
				CDataDirDialog DataDirDialog;
				DataDirDialog.Show(hwndDlg);
			}				
			return TRUE;
		case IDC_CONFIG:
			{				
				CFixApp FixApp;
				FixApp.Show(hwndDlg);
			}
			return TRUE;
		}
		break;

	case WM_CLOSE:
		EndDialog(hwndDlg,0);
		return TRUE;

	}

	return FALSE;
}
