#include "stdafx.h"
#include "Misc.h"

static const wchar_t* s_pszGameName = L"Deus Ex";

bool SetDEP(DWORD dwFlags = PROCESS_DEP_ENABLE)
{
       HMODULE hMod = GetModuleHandleW(L"Kernel32.dll");

		if (!hMod)
		{
			return false;
		}

       typedef BOOL (WINAPI *PSETDEP)(DWORD);

       PSETDEP procSet = (PSETDEP)GetProcAddress(hMod,"SetProcessDEPPolicy");

       if (!procSet)
	   {
		   return false;
	   }

       return procSet(dwFlags)!=FALSE;

}

static bool bUseUserDocs;

bool GetUseUserDocs()
{
	return bUseUserDocs;
}

void SetUseUserDocs(bool bVal)
{
	bUseUserDocs = bVal;
}

/**
Returns game directory in user documents directory
*/
void GetUserDocsDir(wchar_t(& pszBuf)[MAX_PATH])
{
	SHGetFolderPath(NULL,CSIDL_PERSONAL,NULL,NULL,pszBuf);
	PathAppend(pszBuf,s_pszGameName);    
}

/**
Returns System directory in game directory
*/
void GetGameSystemDir(wchar_t(& pszBuf)[MAX_PATH])
{
	GetModuleFileName(NULL,pszBuf,MAX_PATH);
	PathRemoveFileSpec(pszBuf);
}