#include "stdafx.h"
#include "DeusExeFileManager.h"
#include "Misc.h"
#pragma warning(disable:4291) //no matching operator delete found; memory will not be freed if initialization throws an exception

FFileManagerDeusExe::FFileManagerDeusExe()
{		
	GetUserDocsDir(m_szUserDataPath);
	PathAppend(m_szUserDataPath,_T("System")); //The games use paths relative to system, so we're doing that too.
	GetModuleFileName(nullptr, m_szSystemPath, MAX_PATH);
	PathRemoveFileSpec(m_szSystemPath);
	PathCombine(m_szGamePath,m_szSystemPath,_T("..")); //Move up from system directory
#ifdef _DEBUG
	Test();
#endif
}

FFileManagerDeusExe::~FFileManagerDeusExe()
{

}

void FFileManagerDeusExe::Test()
{
	TCHAR szNewPath[MAX_PATH];	
	ToModernFileName(szNewPath,L"bla.txt",'w');
	ToModernFileName(szNewPath,L".\\bla.txt",'w');
	ToModernFileName(szNewPath,L"..\\bla.txt",'w');
	ToModernFileName(szNewPath,L"..\\system\\bla.txt",'w');
	ToModernFileName(szNewPath,L"..\\textures\\bla.txt",'w');
	ToModernFileName(szNewPath,L"..\\..\\bla.txt",'w');
	ToModernFileName(szNewPath,L"D:\\Steam\\steamapps\\common\\Deus Ex\\..\\bla.txt");
	ToModernFileName(szNewPath,L"D:\\Steam\\steamapps\\common\\Deus Ex\\textures\\bla.txt");
	ToModernFileName(szNewPath,L"D:\\Steam\\steamapps\\common\\Deus Ex\\system\\bla.txt");
	ToModernFileName(szNewPath,L"c:\\bla.txt",'w');
	ToModernFileName(szNewPath,L"C:\\Users\\Marijn Kentie\\Documents\\Deus Ex\\System\\bla.txt",'w');
	ToModernFileName(szNewPath,L"C:\\Users\\Marijn Kentie\\Documents\\Deus Ex\\",'w');
}

void FFileManagerDeusExe::ToModernFileName(TCHAR(& szNewName)[MAX_PATH], const TCHAR* pszOldName, char op)
{	
	assert(pszOldName);

	_tcscpy_s(szNewName,pszOldName);

	if(!GetUseUserDocs())
	{			
		return;		
	}
	
	//Make all paths relative to game directory
	if(!PathIsRelative(szNewName))
	{
		//If not in game directory, abort. This facilitates how MakeDirectory() recursively creates directories
		wchar_t szCommonPrefix[MAX_PATH];
		PathCanonicalize(szNewName,pszOldName); //Resolve relative parts of path
		PathCommonPrefix(szNewName,m_szGamePath,szCommonPrefix);
		if(_tcsicmp(szCommonPrefix,m_szGamePath)!=0)
		{
			return;
		}

		//Make path relative to System, like the games' own paths
		PathRelativePathTo(szNewName,m_szSystemPath,FILE_ATTRIBUTE_DIRECTORY,pszOldName,0);
	}

	//Rebase to Documents
	PathCombine(szNewName,m_szUserDataPath,szNewName);
	
	//Create directory if needed
	if(op=='w' && !PathIsDirectory(pszOldName)) //PathIsDirectory needed as PathRemoveFileSpec would strip stuff like 'Save040' to just 'Save'
	{
		wchar_t* pszFileSpec = PathFindFileName(szNewName);
		PathRemoveFileSpec(szNewName);
		if(!PathFileExists(szNewName))
		{
			MakeDirectory(szNewName,1);
		}
		PathAppend(szNewName,pszFileSpec);
	}
	else if(op=='r' && !PathFileExists(szNewName) && PathFileExists(pszOldName) ) //If opening a file that already exists, return original.
	{
		_tcscpy_s(szNewName,pszOldName);
	}

}

FArchive* FFileManagerDeusExe::CreateFileReader( const TCHAR* Filename, DWORD Flags, FOutputDevice* Error )
{
	assert(Filename);
	TCHAR szFilename[MAX_PATH];
	ToModernFileName(szFilename,Filename);
	return FFileManagerWindows::CreateFileReader(szFilename,Flags,Error);
}

FArchive* FFileManagerDeusExe::CreateFileWriter( const TCHAR* Filename, DWORD Flags, FOutputDevice* Error )
{
	assert(Filename);
	TCHAR szFilename[MAX_PATH];
	ToModernFileName(szFilename,Filename,'w');
	return FFileManagerWindows::CreateFileWriter(szFilename,Flags,Error);
}

INT FFileManagerDeusExe::FileSize( const TCHAR* Filename )
{
	assert(Filename);
	TCHAR szFilename[MAX_PATH];
	ToModernFileName(szFilename,Filename);
	return FFileManagerWindows::FileSize(szFilename);
}

UBOOL FFileManagerDeusExe::Copy( const TCHAR* DestFile, const TCHAR* SrcFile, UBOOL ReplaceExisting, UBOOL EvenIfReadOnly, UBOOL Attributes, void (*Progress)(FLOAT Fraction) )
{
	assert(DestFile);
	assert(SrcFile);
	wchar_t szDestFile[MAX_PATH];
	ToModernFileName(szDestFile,DestFile,'w');
	wchar_t szSrcFile[MAX_PATH];
	ToModernFileName(szSrcFile,SrcFile);
	return FFileManagerWindows::Copy(szDestFile,szSrcFile,ReplaceExisting,EvenIfReadOnly,Attributes,Progress);
}

UBOOL FFileManagerDeusExe::Delete( const TCHAR* Filename, UBOOL RequireExists, UBOOL EvenReadOnly)
{
	assert(Filename);
	TCHAR szFilename[MAX_PATH];
	ToModernFileName(szFilename,Filename);
	return FFileManagerWindows::Delete(szFilename,RequireExists,EvenReadOnly);
}

UBOOL FFileManagerDeusExe::Move( const TCHAR* Dest, const TCHAR* Src, UBOOL Replace, UBOOL EvenIfReadOnly, UBOOL Attributes)
{
	assert(Dest);
	assert(Src);
	wchar_t szDest[MAX_PATH];
	ToModernFileName(szDest,Dest);
	wchar_t szSrc[MAX_PATH];
	ToModernFileName(szSrc,Src);
	return FFileManagerWindows::Move(szDest,szSrc,Replace,EvenIfReadOnly,Attributes);
}
	
UBOOL FFileManagerDeusExe::MakeDirectory( const TCHAR* Path, UBOOL Tree )
{
	assert(Path);
	wchar_t szPath[MAX_PATH];
	ToModernFileName(szPath,Path,'w');
	return FFileManagerWindows::MakeDirectory(szPath,Tree);
}

UBOOL FFileManagerDeusExe::DeleteDirectory( const TCHAR* Path, UBOOL RequireExists, UBOOL Tree )
{
	assert(Path);
	wchar_t szPath[MAX_PATH];
	ToModernFileName(szPath,Path);
	return FFileManagerWindows::DeleteDirectory(szPath,RequireExists,Tree);
}

TArray<FString> FFileManagerDeusExe::FindFiles( const TCHAR* Filename, UBOOL Files, UBOOL Directories )
{
	assert(Filename);
	wchar_t szFilename[MAX_PATH];
	ToModernFileName(szFilename,Filename);

	//Look for old style filenames
	auto Result = FFileManagerWindows::FindFiles(Filename,Files,Directories);
		
	if(wcscmp(szFilename,Filename)==0) //Already started out with a new style file
	{
		return Result;
	}

	//Look for new style filenames
	HANDLE hHandle=nullptr;
	WIN32_FIND_DATAW Data;
	hHandle=FindFirstFileW(szFilename,&Data);
	if( hHandle!=INVALID_HANDLE_VALUE )
		do
			if
			(	appStricmp(Data.cFileName,TEXT("."))
			&&	appStricmp(Data.cFileName,TEXT(".."))
            &&	((Data.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY)?Directories:Files) 
            && Result.FindItemIndex(Data.cFileName) == INDEX_NONE ) //Don't list things twice if the game won't be able to tell them apart (i.e. a directory like 'Save001' with no further path will result in the new version being listed twice)
            {
				new(Result)FString(Data.cFileName);
            }
		while( FindNextFileW(hHandle,&Data) );

	if( hHandle )
	{
		FindClose( hHandle );
	}
	return Result;
}
