#pragma once

class FFileManagerDeusExe : public FFileManagerWindows
{
public:
	explicit FFileManagerDeusExe();
	virtual ~FFileManagerDeusExe();	

private:
	void ToModernFileName(TCHAR(& szNewName)[MAX_PATH], const TCHAR* pszOldName, char op = 'r');
	void Test();

	TCHAR m_szUserDataPath[MAX_PATH];
	TCHAR m_szSystemPath[MAX_PATH];
	TCHAR m_szGamePath[MAX_PATH];

//From FFileManagerWindows
public:	
	virtual FArchive* CreateFileReader( const TCHAR* Filename, DWORD Flags, FOutputDevice* Error ) override;
	virtual FArchive* CreateFileWriter( const TCHAR* Filename, DWORD Flags, FOutputDevice* Error ) override;
	virtual INT FileSize( const TCHAR* Filename ) override;
	virtual UBOOL Copy( const TCHAR* DestFile, const TCHAR* SrcFile, UBOOL ReplaceExisting, UBOOL EvenIfReadOnly, UBOOL Attributes, void (*Progress)(FLOAT Fraction) ) override;
	virtual UBOOL Delete( const TCHAR* Filename, UBOOL RequireExists=0, UBOOL EvenReadOnly=0 ) override;
	virtual UBOOL Move( const TCHAR* Dest, const TCHAR* Src, UBOOL Replace=1, UBOOL EvenIfReadOnly=0, UBOOL Attributes=0 ) override;
	virtual UBOOL MakeDirectory( const TCHAR* Path, UBOOL Tree=0 ) override;
	virtual UBOOL DeleteDirectory( const TCHAR* Path, UBOOL RequireExists=0, UBOOL Tree=0 ) override;
	virtual TArray<FString> FindFiles( const TCHAR* Filename, UBOOL Files, UBOOL Directories ) override;
};
