#include "stdafx.h"
#include "Detoureds.h"

/**
GetDiskFreeSpaceExA
*/
static decltype(GetDiskFreeSpaceExA)* TrueGetDiskFreeSpaceExA = GetDiskFreeSpaceExA;

BOOL WINAPI MyGetDiskFreeSpaceExA(LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes)
{
	//The game interprets the returned amount of free disk space as a signed 32 bit value, so clip to that
	BOOL retval = TrueGetDiskFreeSpaceExA(lpDirectoryName,lpFreeBytesAvailableToCaller,lpTotalNumberOfBytes,lpTotalNumberOfFreeBytes);
	lpFreeBytesAvailableToCaller->QuadPart=std::min<ULONGLONG>(lpFreeBytesAvailableToCaller->QuadPart,std::numeric_limits<signed int>::max());
	return retval;
}

bool InitDetours()
{
	if(DetourTransactionBegin()!=NO_ERROR)
	{
		return false;
	}
	if(DetourUpdateThread(GetCurrentThread())!=NO_ERROR)
	{
		return false;		
	}

	if(DetourAttach(reinterpret_cast<PVOID*>(&TrueGetDiskFreeSpaceExA), MyGetDiskFreeSpaceExA)!=NO_ERROR)
	{
		return false;
	}

	if(DetourTransactionCommit()!=NO_ERROR)
	{
		return false;
	}
	return true;
}

bool UninitDetours()
{
	if(DetourTransactionBegin()!=NO_ERROR)
	{
		return false;
	}
	if(DetourUpdateThread(GetCurrentThread())!=NO_ERROR)
	{
		return false;
	}
	if(DetourDetach(reinterpret_cast<PVOID*>(&TrueGetDiskFreeSpaceExA), MyGetDiskFreeSpaceExA)!=NO_ERROR)
	{
		return false;
	}
	if(DetourTransactionCommit()!=NO_ERROR)
	{
		return false;
	}
	return true;
}