#pragma once

class CFixApp
{
public:
	explicit CFixApp();
	virtual ~CFixApp();
	bool Show(const HWND hWndParent) const;

private:	
	void ReadSettings();
	void PopulateDialog();
	void ApplySettings() const;

	static INT_PTR CALLBACK FixAppDialogProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam);

	//Constants
	static const wchar_t* const sm_pszOTPRootWindow;
	static const wchar_t* const sm_pszDefaultRootWindow;
	static const unsigned char  sm_iBPP_16 = 16;
	static const unsigned char  sm_iBPP_32 = 32;

	struct Resolution //These are all ints to match what Unreal loads from the ini file
	{
		unsigned int iX;
		unsigned int iY;
	};

	//Members
	HWND m_hWnd;
	HWND m_hWndCBRenderers;
	HWND m_hWndCBResolutions;
	std::vector<std::wstring> m_Renderers;
	std::deque<Resolution> m_Resolutions; //Don't want push_back to change address
};
