#ifndef CORE_H
#define CORE_H

#include <QSharedPointer>

#include "Settings/settings.h"
#include "Games/gameinfo.h"
#include "Logger/logger.h"
#include "Logger/logprimitive.h"
#include "Database/databasehandle.h"

#include "UdpTasks/beaconserver.h"
#include "TcpTasks/listenserver.h"

class Core : public QObject
{
    Q_OBJECT
public:
    Core(const QString &applicationPath);
    void init();
    void run();
    void shutdown();

private:
    // internal variables
    QString _applicationPath;

    // settings and supported games
    QSharedPointer<Settings>        _configSettings  = QSharedPointer<Settings>(new Settings);
    QSharedPointer<GameInfo>        _gameInfoDetails = QSharedPointer<GameInfo>(new GameInfo);

    // Logging
    QSharedPointer<Logger>          _log = QSharedPointer<Logger>(new Logger);

    // Database access
    QSharedPointer<DatabaseHandle>  _databaseHandle = QSharedPointer<DatabaseHandle>(new DatabaseHandle);

    // Networking services
    QSharedPointer<BeaconServer>    _udpBeaconServer = QSharedPointer<BeaconServer>(new BeaconServer);
    QSharedPointer<ListenServer>    _tcpListenServer = QSharedPointer<ListenServer>(new ListenServer);
};

#endif // CORE_H
