#include "databasehandle.h"

QByteArray DatabaseHandle::compileSyncList(const QStringList &gamenameList,
                                           const int &serverAge_s)
{
    // output list in \\gamename1\\ip:port ip:port\\gamename2\\ip:port ip:port\\final\\ format
    QByteArray compiledList;

    // go through list of gamenames
    QStringListIterator gamenameListNames(gamenameList);
    while ( gamenameListNames.hasNext() )
    {
        // retrieve servers from database
        QString gamename = gamenameListNames.next();
        QSqlQuery q = selectServerList( gamename, serverAge_s);

        // identifier
        compiledList += QStringLiteral("\\%1\\").arg(gamename);

        // iterate through resulting queries and add to compile list
        while (q.next())
        {
            // get ip and port
            QHostAddress   ip   = QHostAddress( q.value(0).toString() );
            unsigned short port = q.value(1).value<unsigned short>();

            // FIXME: as long as other masterserver version do not support IPv6, force to IPv4
            ip = QHostAddress( ip.toIPv4Address() );

            // add to list
            compiledList += QStringLiteral("%1:%2 ").arg(ip.toString(), QString::number(port));

        } // while next
    }

    // terminator after list
    compiledList.append("\\final\\");

    // list compiled
    return compiledList;
}
