#include "databasehandle.h"

// insert, update or delete a server from the list
bool DatabaseHandle::insertServer(const QHostAddress &serverAddress,
                                  const unsigned short &serverPort,
                                  const QString &gamename,
                                  const bool &directBeacon)
{
    // insert query string
    QSqlQuery q;
    QString insertString = "INSERT INTO serverlist (ip, port, gamename, directbeacon) "
                           "VALUES (:ip, :port, :gamename, :directbeacon)";

    // bind values and execute
    q.prepare(insertString);
    q.bindValue(":ip", serverAddress.toString());
    q.bindValue(":port", serverPort);
    q.bindValue(":gamename", gamename);
    q.bindValue(":directbeacon", ( directBeacon ? 1 : 0 ) ); // bool to int

    if ( ! q.exec() )
        return reportQuery(q);

    // was a row inserted?
    return (q.numRowsAffected() > 0);
}
