#include "gameinfo.h"

bool GameInfo::loadGames(const QString &applicationPath)
{
    // determine if file exists
    if ( ! QFile(applicationPath+"/"+_supportPath).exists() )
    {
        // no game info file exists
        QTextStream(stdout) << "No games file found at " << _supportPath << endl
                            << "Please provide the correct file . " << endl;
        return false;
    }

    /**
     * @attention This function assumes that the CSV file is provided in the correct
     * format and with correct values. If the CSV file has incorrect quoting, incorrect
     * comma use or columns that are in the wrong order, none of this will work.
     *
     * TODO: assume that the user is an idiot and thus make this code user-proof.
     */

    // load config file
    QFile supportedFile(applicationPath+"/"+_supportPath);
    if ( ! supportedFile.open(QIODevice::ReadOnly) )
    {
        // error occurred. report and quit.
        QTextStream(stdout) << "Unable to open the game file. Is the file open or in use?" << endl;
        return false;
    }

    // read the game details line by line
    QTextStream csv(&supportedFile);

    // process variables per row
    sGameDetails game;
    int i = 0, j = 0, total = 0, defaultPort = 0;
    bool toInt;

    // skip the header
    bool header = false;
    while ( ! csv.atEnd() )
    {
        // process row
        QString row = csv.readLine();

        // header contains Gamename,Cipher,Default Query Port,Protocol,Game Label
        if (! header )
        {
            header = true;
            continue;
        }

        // manually parse rows to prevent commas splitting game labels
        try {
            // reset counters
            i = 0;
            j = 0;

            // gamename
            j = row.indexOf(',', i+1);
            game.gamename = row.mid(i,j-i).remove('"').toLower(); // convert to lowercase
            i = j+1;

            // cipher
            j = row.indexOf(',', i);
            game.cipher = row.mid(i,j-i).remove('"');
            i = j+1;

            // default port
            j = row.indexOf(',', i);
            defaultPort = row.mid(i,j-i).remove('"').toInt(&toInt);
            game.port = static_cast<unsigned short>( defaultPort );
            i = j+1;

            // protocol
            j = row.indexOf(',', i);
            game.protocol = row.mid(i,j-i).remove('"').toLower() ;
            i = j+1;

            // game label (product name)
            game.label = row.mid(i).remove('"');

            // add to list
            supportedGames.insert(game.gamename, game);
            total++;
        }
        catch (...)
        {
            // on error, print defective line number
            QTextStream(stdout) << "Error processing game details on row " << row << endl;
            continue;
        }

    } // while rows

    // close file
    supportedFile.close();

    // all games parsed. done.
    return (total > 0);
}
