#include "logger.h"

void Logger::displayEvent(const QString &dateTimeStr,
                          const QString &messageType,
                          const QString &message)
{
    // printing to logfile suppressed?
    if ( ! _suppressDisplay.contains(messageType) )
    {
        logPrimitive() << QStringLiteral("[%1][%2]\t%3").arg(dateTimeStr, messageType, message) << endl;
    }
}

void Logger::displayEvent(const QString &messageType,
                          const QString &message)
{
    QString dateTimeStr(QDateTime::currentDateTime().toString("dd-MM-yyyy HH:mm:ss:zzz"));
    this->displayEvent(dateTimeStr, messageType, message);
}
