#ifndef LOGGER_H
#define LOGGER_H

#include <QString>
#include <QHash>
#include <QDateTime>
#include <QTextStream>
#include <QDir>
#include <QFile>

#include "Settings/structsettings.h"
#include "Core/version.h"
#include "logprimitive.h"

enum cyclePeriod { never = 0, yearly, monthly, weekly, daily };

class Logger
{
public:
    Logger();
    bool init(const sSettings &settings,
              const QString   &applicationPath);
    void stop();

    void displayEvent(const QString &dateTimeStr,
                      const QString &messageType,
                      const QString &message);
    void displayEvent(const QString &messageType,
                      const QString &message);

    void logEvent(const QString &messageType,
                  const QString &message);
private:
    // settings
    QString _applicationPath;
    QString _logPath = "../log";
    QString _logLabel = "MasterServer-"+SHORT_VER; // log file name label
    QString _logFileName;
    QString _suppressLog;
    QString _suppressDisplay;
    cyclePeriod _cycle;

    // file operations
    QFile _logFile;
    bool cycleLogFile();
    bool openLogFile();
    void closeLogFile();
    bool writeLogFile(const QString message);
};

#endif // LOGGER_H
