#include "logger.h"

bool Logger::init(const sSettings &settings,
                  const QString &applicationPath)
{
    this->_applicationPath = applicationPath;

    // test if log directory exists
    QDir logDir(applicationPath+"/"+_logPath);

    if ( ! logDir.mkpath(".") )
    {
        QTextStream(stdout) << "Failed to access log directory at " + _logPath << endl
                            << "Please create the director and/or apply relevant permissions." << endl;
        return false;
    }

    // log cycling
    const QHash<QString, cyclePeriod> logCycling =
    {
        {"never",   never},
        {"yearly",  yearly},
        {"monthly", monthly},
        {"weekly",  weekly},
        {"daily",   daily}
    };

    // set other values
    _cycle           = logCycling.value( settings.Logging.cycle );
    _suppressLog     = settings.Logging.suppressLog;
    _suppressDisplay = settings.Logging.suppressDisplay;

    // cycling initialisation ("never" is also a cycle)
    if ( ! cycleLogFile() )
    {
        QTextStream(stdout) << "Failed to access log file " + _logFileName + " at " + _logPath << endl;
        return false;
    }
    return true;
}
