#include "logger.h"

/**
 * @brief Open the logfile specified by logFileName in directory ./log.
 * @return false if unable to open the file.
 */
bool Logger::openLogFile()
{
    // verify that there is no open logfile already
    if ( _logFile.openMode() == QIODevice::NotOpen)
    {
        // set new log file
        _logFile.setFileName(_applicationPath+"/"+_logPath + "/" + _logFileName);
        return _logFile.open(QIODevice::WriteOnly | QIODevice::Append | QIODevice::Text);
    }
    // else:
    // file already open, can not get a lock
    return false;
}

/**
 * @brief close existing/opened log file
 */
void Logger::closeLogFile()
{
    // close file if open. if already closed, ignore.
    _logFile.close();
}
