QT += core network sql
QT -= gui

CONFIG += c++11 console
CONFIG -= app_bundle

# The following define makes your compiler emit warnings if you use
# any Qt feature that has been marked deprecated (the exact warnings
# depend on your compiler). Please consult the documentation of the
# deprecated API in order to know how to port your code away from it.
DEFINES += QT_DEPRECATED_WARNINGS

# You can also make your code fail to compile if it uses deprecated APIs.
# In order to do so, uncomment the following line.
# You can also select to disable deprecated APIs only up to a certain version of Qt.
#DEFINES += QT_DISABLE_DEPRECATED_BEFORE=0x060000    # disables all the APIs deprecated before Qt 6.0.0

SOURCES += \
        Core/core.cpp \
        Core/init.cpp \
        Core/run.cpp \
        Database/databasehandle.cpp \
        Database/dbcompileserverlist.cpp \
        Database/dbcompilesynclist.cpp \
        Database/dbcreatetables.cpp \
        Database/dbgetgamenames.cpp \
        Database/dbgetuplinklist.cpp \
        Database/dbinit.cpp \
        Database/dbinsertserver.cpp \
        Database/dbselectqueries.cpp \
        Database/dbupdateserver.cpp \
        Games/gameinfo.cpp \
        Games/loadgames.cpp \
        Logger/logcycle.cpp \
        Logger/logdisplay.cpp \
        Logger/logevent.cpp \
        Logger/logger.cpp \
        Logger/loginit.cpp \
        Logger/logopenfile.cpp \
        Logger/logwritefile.cpp \
        Protocols/GameSpy0/algorithm.cpp \
        Protocols/GameSpy0/gamespy0.cpp \
        Protocols/GameSpy0/securevalidate.cpp \
        Protocols/overrides.cpp \
        Settings/loadsettings.cpp \
        Settings/settings.cpp \
        Settings/writesettings.cpp \
        TcpTasks/listenserver.cpp \
        TcpTasks/tcpclient.cpp \
        TcpTasks/tcpclientread.cpp \
        UdpTasks/beaconserver.cpp \
        UdpTasks/localbeacon.cpp \
        UdpTasks/onheartbeattimer.cpp \
        UdpTasks/replyquery.cpp \
        UdpTasks/resolve.cpp \
        UdpTasks/senduplink.cpp \
        UdpTasks/udplisten.cpp \
        UdpTasks/udponread.cpp \
        UdpTasks/udpontimeout.cpp \
        UdpTasks/uplink.cpp \
        main.cpp

# Default rules for deployment.
qnx: target.path = /tmp/$${TARGET}/bin
else: unix:!android: target.path = /opt/$${TARGET}/bin
!isEmpty(target.path): INSTALLS += target

HEADERS += \
    Core/core.h \
    Core/structs.h \
    Core/version.h \
    Database/databasehandle.h \
    Games/gameinfo.h \
    Games/structgamedetails.h \
    Logger/logger.h \
    Logger/logprimitive.h \
    Protocols/GameSpy0/gamespy0.h \
    Protocols/GameSpy0/securevalidate.h \
    Protocols/overrides.h \
    Settings/settings.h \
    Settings/structsettings.h \
    TcpTasks/listenserver.h \
    TcpTasks/tcpclient.h \
    UdpTasks/beaconserver.h
