#ifndef SETTINGS_H
#define SETTINGS_H

#include <QFile>
#include <QSettings>

#include "structsettings.h"
#include "Logger/logprimitive.h"

class Settings
{
public:
    Settings();
    bool loadSettings(const QString &applicationPath);

    // accessible settings struct
    sSettings settings;

private:
    // generate a new settings file
    void writeSettings();

    // settings file location
    QString _applicationPath;
    QString _settingsPath = "../data/MasterServer-Settings.ini";
};

#endif // SETTINGS_H
