#ifndef STRUCTSETTINGS_H
#define STRUCTSETTINGS_H

#include <QString>
#include <QList>

// other master servers and sync options
struct sSyncServer {
    QString            remoteAddress; // list domain string, not QHostAddress
    unsigned short int beaconPort = 27900;
    unsigned short int listenPort = 28900;
};

// cascaded struct of configuration settings
struct sSettings
{
    // contact information
    struct sPublicInformation
    {
        QString hostname;
        QString adminName;
        QString contact;
    }
    PublicInformation;

    // network settings & timeouts
    struct sNetwork
    {
        unsigned short int beaconPort = 27900;
        unsigned short int listenPort = 28900;

        int     serverttl_s = 1800;
        bool    allowLocal  = false;
    }
    Network;

    // synchronisation settings (works only with 333networks-compatible masterservers)
    struct sSyncer {

        // uplink settings enabled by default
        bool doUplink = true;

        // syncer settings enabled by default
        bool doSync = true;

        // sync games (which games to sync)
        QString syncGames = "all";

        // list of servers to sync
        QList<sSyncServer> syncServers;

    } Syncer;

    // database configuration
    struct sDatabase
    {
        // database type
        QString databaseType = "QSQLITE";

        // Database login ( for MySQL, Postgres )
        QString dbname  = "";
        QString user    = "";
        QString pass    = "";
    }
    Database;

    // log settings
    struct sLogging
    {
        QString cycle           = "never";
        QString suppressLog     = "debug";
        QString suppressDisplay = "none";
    }
    Logging;

    // generate our session/identification string, to prevent self-syncing
    QString masterserverIdentity; // msid value
};


#endif // STRUCTSETTINGS_H
