#ifndef LISTENSERVER_H
#define LISTENSERVER_H

#include <QTimer>
#include <QTcpServer>
#include <QTcpSocket>

#include "Settings/structsettings.h"
#include "Games/gameinfo.h"
#include "Logger/logger.h"
#include "Database/databasehandle.h"
#include "tcpclient.h"

class ListenServer: public QObject
{
    Q_OBJECT
public:
    ListenServer();
    bool listen(const sSettings                      &settings,
                const QSharedPointer<GameInfo>       &gameInfoDetails,
                const QSharedPointer<DatabaseHandle> &databaseHandle,
                const QSharedPointer<Logger>         &log);

private:
    // interfaces
    QSharedPointer<GameInfo>        _gameInfoDetails;
    QSharedPointer<DatabaseHandle>  _databaseHandle;
    QSharedPointer<Logger>          _log;

    // tcp server
    QTcpServer  _tcpServer;
    int         _serverttl_s;
    QString     _masterserverIdentity;

signals:

private slots:
    void onTcpConnection();

};

#endif // LISTENSERVER_H
