#include "beaconserver.h"

void BeaconServer::onHeartbeatTimer()
{
    // get list with masterserver addresses from database
    QList<sServer> dbList = _databaseHandle->getUplinkList(_settings.Network.serverttl_s);

    // add/merge resolved uplink address list
    QListIterator<sSyncServer> syncList(_settings.Syncer.syncServers);
    while ( syncList.hasNext() )
    {
        sSyncServer syncServer = syncList.next();
        if ( _uplinkAddress.contains(syncServer.remoteAddress) )
        {
            // add resolved address to list
            sServer remoteServer;
            remoteServer.ip   = _uplinkAddress.value(syncServer.remoteAddress);
            remoteServer.port = syncServer.beaconPort;

            // check if not duplicate
            if ( ! dbList.contains(remoteServer) )
            {
                dbList.append(remoteServer);
            }
            else
            {
                // test custom operator==(sServer, sServer)
                _log->logEvent("debug", QStringLiteral("duplicate uplink %1:%2")
                        .arg(remoteServer.ip.toString(), QString::number(remoteServer.port)));
            }
        }
    }

    // for the entire list of masterserver addresses, send out beacons
    QListIterator<sServer> list(dbList);
    while ( list.hasNext() )
    {
        sServer serv = list.next();
        this->sendUplink(serv.ip, serv.port);
    }
}
