#include "beaconserver.h"

void BeaconServer::onResolveTimer()
{
    // write list of servers
    QListIterator<sSyncServer> syncRecordIterator(_settings.Syncer.syncServers);

    while ( syncRecordIterator.hasNext() )
    {
        // get next address
        QString domainName = syncRecordIterator.next().remoteAddress;
        QHostInfo::lookupHost(domainName, this,
            [this, domainName] (const QHostInfo &host)
            {
                // errors during lookup?
                if ( host.error() == QHostInfo::NoError and ! host.addresses().empty() )
                {
                    // overwrite or insert resolved domain and address
                    _uplinkAddress[domainName] = host.addresses().first();
                    _log->logEvent("resolve", QStringLiteral("%1 resolved to %2")
                                   .arg( domainName, host.addresses().first().toString()) );
                }
                else
                {
                    // delete entry and hope next lookup is more successful
                    _uplinkAddress.remove(domainName);
                    _log->logEvent("lookup",QStringLiteral("cannot resolve %1: %2")
                                   .arg( domainName, host.errorString()) );
                }
            }
        );
    }
}
