#include "beaconserver.h"

// soft timeout. every <timeout>, remove all servers older than <timeout> from the list.
// that means a server has a maximum wait/response time of 2*<timeout>
void BeaconServer::onUdpTimedOut()
{
    // iterate through the server list
    QHashIterator<QString, HeartBeat> list(_beaconList);
    while (list.hasNext())
    {
        // select
        list.next();

        // check passed time: add date < remove date?
        qint64 currentTime = QDateTime::currentSecsSinceEpoch();
        if ( list.value().time < currentTime - _timeOutTime_ms/1000 )
        {
            // if timeout has passed, remove the server from the list
            _log->logEvent("udp", QStringLiteral("%1 timed out").arg(list.key()));
            _beaconList.remove(list.key());
        }
    }

    // debugging
    if (_beaconList.size() > 0)
        _log->logEvent("debug", QStringLiteral("there are %1 remaining items").arg(_beaconList.size()));
}
