# Master Server Qt5/C++
---

## DESCRIPTION
Qt5/C++ implementation of the 333networks master server. Receives UDP beacons from game servers and provides serverlists for game clients. At the time of writing, only the GameSpy_v0 protocol is supported.

This is a work in progress. Please join us on [discord](https://discord.gg/qbbTaGA) and participate in one or more of the workgroups or consider making a donation.

Website: [http://333networks.com](http://333networks.com)

## INSTALL
Download Qt5 from [https://www.qt.io/download](https://www.qt.io/download) and use the maintenance tool to install the Qt5 libraries for v5.9.5 or above. Install the database server for the database type that you want to use (SQLite, MySQL or Postgresql).

## CONFIGURATION
Configure the masterserver with the settings provided in `data/MasterServer-Settings.ini`:

In the `[Database]` section, provide a database type using the Qt5 identifier:
* SQLite: `QSQLITE`
* MySQL: `QMYSQL`
* Postgres: `QPSQL`

SQLite does not require further settings. For MySQL and PostgreSQL, the user must create and set a database name, username and password and provide these in the `[Database]` section.
```
[Database]
Type=QSQLITE
DatabaseName=
Password=
Username=
```

Logfiles are stored in the `log` folder and can be cycled `never`, `yearly`, `monthly`, `weekly` and `daily`. Output to the console window can be enabled or disabled. It is possible to suppress certain message types, for example:

* `[2019-10-31 16:19:22.283] [example1] message to be suppressed.`

Adding "`example1`" to the `SuppressLog=debug example1` value suppresses messages of the types "debug" and "example1" in the log file.
```
[Logging]
CycleLogs=weekly
SuppressLog=debug
SuppressDisplay=none
```

The masterserver uses an UDP and TCP server. Both network ports can be configured with the `BeaconPort` (UDP) and `ListenPort` (TCP) settings. Local game servers can be prevented from being listed with their local address. The cache time for game servers (since the last beacon) is set with the `ServerLifeTimeSeconds`.
```
[Network]
AllowLocal=false
BeaconPort=27900
ListenPort=28900
ServerLifeTimeSeconds=1800
```

Uplinking the status to other 333networks masterservers can be set with `DoUplink`. Synchronisation of serverlists can be set with `DoSync`. Setting `size` is required to determine the amount of servers in the provided list. Servers can be added to the uplink/syncer list in the format `"address, beaconPort, listenPort"`. With `SyncGames` can be selected which games are synchronised: default setting `all` requests all available gameservers from the remote masterserver. In the example below, the values `ut unreal deusex` synchronise *only* specified games. More gamenames can be found in the *Supported Games* file below.
```
[Syncer]
size=2
1\SyncServer="master.333networks.com, 27900, 28900"
2\SyncServer="master.errorist.tk, 27900, 28900"
SyncGames=ut unreal deusex
DoUplink=true
DoSync=true
```

Before a masterserver can be operated, your public details **must be set**. This is to prevent confusion in the community about who is responsible for the masterserver and the games it supports.
```
[PublicDetails]
Hostname=master.example.com
AdminName=John Doe
Contact=John.Doe@example.com
```

### Supported Games
Game support depends on the protocol and the authentication data that is provided in `data/SupportedGames.csv`. This spreadsheet contains the means to validate the games, use a default port for game servers and description of the used protocol. Changing these values may prevent servers and clients from connecting.

## RUNNING
Start the program `./MasterServer-linux-amd64` from the `bin` folder in console or terminal. Linux users may have to set execution permissions with `chmod +x MasterServer-linux-amd64` first.

## KNOWN ISSUES
The following issues are known to us and do not to be reported:
* documentation is lacking in general;
* MySQL support has not been tested. We have no idea if it works;
* status query and validation of new remote servers is included in source-code, but not compiled in the executable;
* syncing with other masterservers is included in source-code, but not compiled in the executable.

## DISCLAIMER
The software is provided "as is". Darkelarious and 333networks are not liable or responsible for the accuracy or completeness of the provided software or documentation.

More on [333networks](http://333networks.com/disclaimer).

## COPYING
Copyright (c) 2019 Darkelarious & 333networks

More on [333networks](http://333networks.com/disclaimer).
