#include "core.h"

void Core::init() {

    // randomize
    qsrand(static_cast<unsigned int>(QDateTime::currentMSecsSinceEpoch()));

    // announce startup -----------------------------------------------------------------
    logPrimitive() << "*** Starting 333networks Master Server ***" << endl;

    // load config settings from file
    if ( ! _configSettings->loadSettings(_applicationPath) )
        this->shutdown();
    logPrimitive() << "[ok] settings loaded" << endl;

    // set our own 12-byte identifier
    _configSettings->settings.masterserverIdentity = genChallengeString(12, true);
    if (DEBUG) logPrimitive() << "[ok] identify in sync as " << _configSettings->settings.masterserverIdentity << endl;

    // load game info from file
    if ( ! _gameInfoDetails->loadGames(_applicationPath) )
        this->shutdown();
    logPrimitive() << "[ok] game info loaded" << endl;

    // logger init
    if ( ! _log->init(_configSettings->settings, _applicationPath ) )
        this->shutdown();
    logPrimitive() << "[ok] logfile active" << endl;

    // init database
    if ( ! _databaseHandle->init(_configSettings->settings, _applicationPath) )
        this->shutdown();
    logPrimitive() << "[ok] database configured" << endl;
}
