#include "core.h"

void Core::run()
{
    // in run mode ----------------------------------------------------------------------
    _log->logEvent("info", "init complete, entering runmode...");

    // udp beacon server
    if ( ! _udpBeaconServer->init(_configSettings->settings,
                                  _gameInfoDetails,
                                  _databaseHandle,
                                  _log) ) this->shutdown();
    if ( ! _udpBeaconServer->listen() ) this->shutdown();

    // tcp client server
    if ( ! _tcpListenServer->listen(_configSettings->settings,
                                    _gameInfoDetails,
                                    _databaseHandle,
                                    _log) ) this->shutdown();

    // do uplinks
    if ( ! _udpBeaconServer->uplink() ) this->shutdown();

    // sync scheduler
    if ( ! _syncScheduler->init(_configSettings->settings,
                                _gameInfoDetails,
                                _databaseHandle,
                                _log) ) this->shutdown();
    _syncScheduler->scheduleSyncer();

    // server checker
    if ( ! _serverCheckerScheduler->init(_configSettings->settings,
                                         _gameInfoDetails,
                                         _databaseHandle,
                                         _log) ) this->shutdown();
    _serverCheckerScheduler->scheduleChecker();
}
