#ifndef SERVERCHECKERSCHEDULER_H
#define SERVERCHECKERSCHEDULER_H

#include <QTimer>
#include <QHostAddress>
#include <QNetworkDatagram>
#include <QUdpSocket>
#include <QHash>
#include <QList>

#include "Core/structs.h"
#include "version.h"
#include "Settings/structsettings.h"
#include "Games/gameinfo.h"
#include "Logger/logger.h"
#include "Database/databasehandle.h"
#include "Protocols/GameSpy0/gamespy0.h"
#include "Protocols/GameSpy0/securevalidate.h"

class ServerCheckerScheduler: public QObject
{
    Q_OBJECT
public:
    ServerCheckerScheduler();
    bool init (const sSettings                      &settings,
               const QSharedPointer<GameInfo>       &gameInfoDetails,
               const QSharedPointer<DatabaseHandle> &databaseHandle,
               const QSharedPointer<Logger>         &log);
    bool scheduleChecker();

private:
    bool _init = false;

    sSettings                       _settings;
    QSharedPointer<GameInfo>        _gameInfoDetails;
    QSharedPointer<DatabaseHandle>  _databaseHandle;
    QSharedPointer<Logger>          _log;

    // udp checker socket
    QUdpSocket _udpSocket;

    // timer to sweep up abandoned beacons
    QTimer _cycleTimer;
    QTimer _nextTimer;

    // settings
    int _cycleTime_ms = 15 * 60 * 1000; // reset every 15 minutes
    int _nextTime_ms     = 250;         // 4 outgoing requests per second
    int  _timeOutTime_ms = 5000;        // udp timeout (s)

    // store information about unverified servers
    QHash<QString, HeartBeat> _beaconList;

    // lists and indices
    QList<QHash<QString, QString>> _pendingList;
    int _pendingIndex = 0;
    int _serverIndex  = -1; // iterate through database serverlist

    // function to check server status
    void sendUdpStatus(const QHostAddress   &ip,
                       const unsigned short &port,
                       const QString        &gamename,
                       const bool           &doChallenge);

private slots:
    void onCheckerCycle();
    void onCheckNextServer();
    void onCheckerResponse();
};

#endif // SERVERCHECKERSCHEDULER_H
